﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Argos_3D_P100_Visualizer
{
    public class Statistics
    {
        #region private variables
        private List<ListElement> _list;
        private int _size, _xResRoi = -1, _yResRoi = -1;
        #endregion

        #region public proterties
        public int MaxSize
        {
            get
            {
                return _size;
            }
            set
            {
                lock (this)
                {
                    _size = value;
                    while (_list.Count >= _size)
                    {
                        _list.RemoveAt(0);
                    }
                }
            }
        }
        public int FillSize
        {
            get
            {
                return _list.Count;
            }
        }
        public int XresRoi
        {
            get
            {
                return _xResRoi;
            }
            set
            {
                _xResRoi = value;
            }
        }
        public int YresRoi
        {
            get
            {
                return _yResRoi;
            }
            set
            {
                _yResRoi = value;
            }
        }
        #endregion

        public Statistics()
        {
            _list = new List<ListElement>();
        }

        public Statistics(int max_size)
        {
            _list = new List<ListElement>();
            MaxSize = max_size;
        }

        #region public functions
        public void Reset()
        {
            lock (_list)
            {
                _list = new List<ListElement>();
            }
        }

        public void AddElementRingBuffering(List<double> data, int xres, int yres)
        {
            AddElementRingBuffering(data, xres, yres, DateTime.Now);
        }
        public void AddElementRingBuffering(List<double> data, int xres, int yres, DateTime timestamp)
        {
            lock (_list)
            {
                while (_list.Count >= _size)
                {
                    _list.RemoveAt(0);
                }
                if (xres * yres >= data.Count)
                {
                    _list.Add(new ListElement(data, xres, yres, timestamp));
                }
            }
        }


        public void AddElement(List<double> data, int xres, int yres)
        {
            AddElement(data, xres, yres, DateTime.Now);
        }
        public void AddElement(List<double> data, int xres, int yres, DateTime timestamp)
        {
            lock (_list)
            {
                if (_list.Count < _size && xres*yres >= data.Count)
                {
                    _list.Add(new ListElement(data, xres, yres, timestamp));
                }
            }
        }

        public List<double> GetAverage()
        {
            List<double> result = new List<double>();
            lock (_list)
            {
                if (_list.Count > 0)
                {
                    int nCount = _list[0].List.Count;
                    if (_xResRoi == -1 || _yResRoi == -1)
                    {
                        foreach (ListElement element in _list)
                        {
                            if (element.List.Count != nCount)
                            {
                                return result;
                            }
                        }
                        for (int j = 0; j < nCount; j++)
                        {
                            double avg = 0.0;
                            for (int i = 0; i < _list.Count; i++)
                            {
                                avg += _list[i].List[j];
                            }
                            result.Add(avg / (double)_list.Count);
                        }
                    }
                    else
                    {
                        foreach (ListElement element in _list)
                        {
                            if (element.Xres < _xResRoi || element.Yres < _yResRoi)
                            {
                                return result;
                            }
                        }
                        for (int x = 0; x < _xResRoi; x++)
                        {
                            for (int y = 0; y < _yResRoi; y++)
                            {
                                double avg = 0.0;
                                foreach (ListElement frame in _list)
                                {
                                    int x_off = (frame.Xres - _xResRoi) >> 1;
                                    int y_off = (frame.Yres - _yResRoi) >> 1;
                                    avg += frame.List[x + x_off + (y + y_off) * frame.Xres];
                                }
                                result.Add(avg / (double)_list.Count);
                            }
                        }
                    }
                }
            }
            return result;
        }

        public List<double> GetStdDeviation(List<double> avg)
        {
            List<double> result = new List<double>();
            lock (_list)
            {
                if (_list.Count > 0)
                {
                    int nCount = _list[0].List.Count;
                    if (_xResRoi == -1 || _yResRoi == -1)
                    {
                        foreach (ListElement element in _list)
                        {
                            if (element.List.Count != nCount)
                            {
                                return result;
                            }
                        }
                        for (int j = 0; j < nCount; j++)
                        {
                            double dev = 0.0;
                            for (int i = 0; i < _list.Count; i++)
                            {
                                dev += (_list[i].List[j] - avg[j]) * (_list[i].List[j] - avg[j]);
                            }
                            dev = dev / _list.Count;
                            dev = Math.Sqrt(dev);
                            result.Add(dev);
                        }
                    }
                    else
                    {
                        foreach (ListElement element in _list)
                        {
                            if (element.Xres < _xResRoi || element.Yres < _yResRoi)
                            {
                                return result;
                            }
                        }
                        int i = 0;
                        for (int x = 0; x < _xResRoi; x++)
                        {
                            for (int y = 0; y < _yResRoi; y++)
                            {
                                double dev = 0.0;
                                foreach (ListElement frame in _list)
                                {
                                    int x_off = (frame.Xres - _xResRoi) >> 1;
                                    int y_off = (frame.Yres - _yResRoi) >> 1;
                                    dev += (frame.List[x + x_off + (y + y_off) * frame.Xres] - avg[i]) * (frame.List[x + x_off + (y + y_off) * frame.Xres] - avg[i]);
                                }
                                dev = dev / (double)_list.Count;
                                dev = Math.Sqrt(dev);
                                result.Add(dev);
                                i++;
                            }
                        }
                    }
                }
            }
            return result;
        }
        #endregion

        #region public classes
        public class ListElement
        {
            public List<double> List { get; private set; }
            public DateTime Timestamp { get; private set; }
            public int Xres { get; private set; }
            public int Yres { get; private set; }

            public ListElement(List<double> list, int xres, int yres)
            {
                List = list;
                Timestamp = DateTime.Now;
                Xres = xres;
                Yres = yres;
            }
            public ListElement(List<double> list, int xres, int yres, DateTime date)
            {
                List = list;
                Timestamp = date;
                Xres = xres;
                Yres = yres;
            }
        }
        #endregion
    }
}
